//
//  ViewModifiers.swift
//  Do It
//
//  Created by Jim Dovey on 2/4/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI
import Combine

struct DoubleShadow: ViewModifier {
    private var radius: CGFloat
    
    init(_ radius: CGFloat = 10.0) {
        self.radius = radius
    }
    
    func body(content: Content) -> some View {
        content
            .shadow(color: Color.black.opacity(0.1),
                    radius: radius, x: 0, y: radius * 1.2)
            .shadow(color: Color.black.opacity(0.2),
                    radius: max(radius/10, 1), x: 0, y: 1)
    }
}

struct BorderedTextField: ViewModifier {
    func body(content: Content) -> some View {
        content
            .multilineTextAlignment(.center)
            .padding(.vertical, 12)
            .background(
                RoundedRectangle(cornerRadius: 10, style: .continuous)
                    .foregroundColor(Color(UIColor.tertiarySystemFill))
            )
    }
}

extension View {
    func doubleShadow(radius: CGFloat = 10) -> some View {
        modifier(DoubleShadow(radius))
    }
}

extension Text {
    func filledPlatter() -> some View {
        modifier(BorderedTextField())
    }
}

extension TextField {
    func filledPlatter() -> some View {
        modifier(BorderedTextField())
    }
}

struct ViewModifiers_Previews: PreviewProvider {
    static var _sampleText: String = "Sample Text"
    static var sampleText: Binding<String> = Binding(
        get: { _sampleText }, set: { _sampleText = $0 })

    static var previews: some View {
        Group {
            Circle()
                .frame(width: 300, height: 300)
                .foregroundColor(.white)
                .modifier(DoubleShadow())

            Circle()
                .frame(width: 300, height: 300)
                .foregroundColor(.white)
                .modifier(DoubleShadow(20))

            Circle()
                .frame(width: 300, height: 300)
                .foregroundColor(.white)
                .modifier(DoubleShadow(6))

            Text("Start Making Things")
                .padding(.horizontal)
                .modifier(BorderedTextField())

            TextField("Title", text: sampleText)
                .modifier(BorderedTextField())
        }
        .previewLayout(.fixed(width: 350, height: 350))
    }
}
